unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure ListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBox1DragDrop(Sender, Source: TObject; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := (Source is TListBox);
end;

procedure TForm1.ListBox1DragDrop(Sender, Source: TObject; X, Y: Integer);
var
  Item : String;
  PosDrop : Integer;
begin
  if Source <> Sender then begin
    with (Source as TListbox) do begin
      Item := Items[ItemIndex];
      Items.Delete(ItemIndex);
    end;
    (Sender as TListBox).Items.Add(Item);
  end
  else
    with (Sender as TListbox) do begin
      PosDrop := ItemAtPos(Point(X,Y),True);
      if PosDrop < 0  then
        PosDrop := Items.Count-1;
      Items.Move(ItemIndex,PosDrop);
      ItemIndex := PosDrop;
    end;
end;

end.
